/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.motion;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.felnull.otyacraftengine.client.motion.Motion;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MotionLoader {
    public static final Logger LOGGER = LogManager.getLogger(MotionLoader.class);
    private static final Gson GSON = new Gson();
    private final Map<ResourceLocation, Motion> motions = new HashMap<ResourceLocation, Motion>();

    protected MotionLoader(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        profilerFiller.m_7242_();
        for (ResourceLocation id : resourceManager.m_6540_("oe_motion", path -> path.endsWith(".json"))) {
            profilerFiller.m_6180_(id.toString());
            try (InputStream stream = resourceManager.m_142591_(id).m_6679_();
                 InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                JsonObject jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                String p = id.m_135815_();
                this.motions.put(new ResourceLocation(id.m_135827_(), p.substring("oe_motion/".length(), p.length() - ".json".length())), Motion.of(jo));
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading motion resource json " + id, (Throwable)e);
            }
            profilerFiller.m_7238_();
        }
        profilerFiller.m_7241_();
    }

    public Map<ResourceLocation, Motion> getMotions() {
        return ImmutableMap.copyOf(this.motions);
    }
}

